Module Module1
    
    Sub Main()
        ' Construire une voiture.
        Dim buddha As Car = New Car("Buddha", 100, 20)
        buddha.CrankTunes(True)

        ' Essayer d'emballer !
        Try
            Dim i As Integer
            For i = 0 To 10
                buddha.SpeedUp(10)
            Next
        Catch e As CarIsDeadException
            Console.WriteLine(e.Message)
            Console.WriteLine(e.StackTrace)
        Catch e As ArgumentOutOfRangeException
            Console.WriteLine(e.Message)
            Console.WriteLine(e.StackTrace)
        Finally
            ' Ceci arrive dans tous les cas.
            buddha.CrankTunes(False)
        End Try

        OldStyleError()
        SpecialErrorForBuddha()
    End Sub

    Public Sub SpecialErrorForBuddha()
        Dim b As New Car("Buddha", 50, 0)
        Try
            Dim i As Integer
            For i = 0 To 10
                b.SpeedUp(10)
            Next
        Catch e As CarIsDeadException When b.petName = "Buddha"
            Console.WriteLine("Buddha est hors-service...")
        Catch
            Console.WriteLine("Une voiture est hors-service...")
        End Try
    End Sub

    ' Beurk!
    Public Sub OldStyleError()
        Console.WriteLine()
        Console.WriteLine("Ancien type d'erreur...")
        On Error Goto OOPS
        Dim c As New Car("Bill", 100, 0)
        Dim i As Integer
        For i = 0 To 10
            c.SpeedUp(10)
        Next
        Exit Sub
OOPS:
        Console.WriteLine(Err.Description())
        Dim e As Exception = Err.GetException()
        Console.WriteLine(e.Message)
    End Sub
End Module
